/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.assets.entities.item.model;

import java.util.ArrayList;
import java.util.List;
import technology.rocketjump.undermount.assets.entities.item.model.ItemPlacement;
import technology.rocketjump.undermount.assets.entities.item.model.ItemSize;
import technology.rocketjump.undermount.assets.entities.item.model.ItemStyle;
import technology.rocketjump.undermount.assets.entities.model.EntityAssetType;
import technology.rocketjump.undermount.entities.model.physical.item.ItemEntityAttributes;

public class ItemEntityAssetDescriptor {
    private String uniqueName;
    private EntityAssetType type;
    private String itemTypeName;
    private List<String> itemTypeNames;
    private int minQuantity = 1;
    private int maxQuantity = 1;
    private ItemSize itemSize;
    private ItemStyle itemStyle;
    private List<ItemPlacement> itemPlacements = new ArrayList<ItemPlacement>();

    public boolean matches(ItemEntityAttributes entityAttributes) {
        if (this.itemTypeName != null && !this.itemTypeName.equals(entityAttributes.getItemType().getItemTypeName())) {
            return false;
        }
        if (this.itemTypeNames != null && !this.itemTypeNames.contains(entityAttributes.getItemType().getItemTypeName())) {
            return false;
        }
        if (this.minQuantity > entityAttributes.getQuantity() || this.maxQuantity < entityAttributes.getQuantity()) {
            return false;
        }
        if (this.itemSize != null && entityAttributes.getItemSize() != null && !this.itemSize.equals((Object)entityAttributes.getItemSize())) {
            return false;
        }
        return this.itemStyle == null || entityAttributes.getItemStyle() == null || this.itemStyle.equals((Object)entityAttributes.getItemStyle());
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public void setUniqueName(String uniqueName) {
        this.uniqueName = uniqueName;
    }

    public EntityAssetType getType() {
        return this.type;
    }

    public void setType(EntityAssetType type) {
        this.type = type;
    }

    public String getItemTypeName() {
        return this.itemTypeName;
    }

    public void setItemTypeName(String itemTypeName) {
        this.itemTypeName = itemTypeName;
    }

    public List<String> getItemTypeNames() {
        return this.itemTypeNames;
    }

    public void setItemTypeNames(List<String> itemTypeNames) {
        this.itemTypeNames = itemTypeNames;
    }

    public ItemSize getItemSize() {
        return this.itemSize;
    }

    public void setItemSize(ItemSize itemSize) {
        this.itemSize = itemSize;
    }

    public int getMinQuantity() {
        return this.minQuantity;
    }

    public void setMinQuantity(int minQuantity) {
        this.minQuantity = minQuantity;
    }

    public int getMaxQuantity() {
        return this.maxQuantity;
    }

    public void setMaxQuantity(int maxQuantity) {
        this.maxQuantity = maxQuantity;
    }

    public ItemStyle getItemStyle() {
        return this.itemStyle;
    }

    public void setItemStyle(ItemStyle itemStyle) {
        this.itemStyle = itemStyle;
    }

    public List<ItemPlacement> getItemPlacements() {
        return this.itemPlacements;
    }

    public void setItemPlacements(List<ItemPlacement> itemPlacements) {
        this.itemPlacements = itemPlacements;
    }
}

